/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.client.DisableStaminaRender;
import tictim.paraglider.client.InGameStaminaWheelRenderer;
import tictim.paraglider.client.StaminaWheelRenderer;
import tictim.paraglider.client.screen.ParagliderSettingScreen;
import tictim.paraglider.client.screen.StatueBargainScreen;

@Mod.EventBusSubscriber(modid="paraglider", value={Dist.CLIENT})
public final class ParagliderClientEventHandler {
    private static KeyBinding paragliderSettingsKey;
    private static final DecimalFormat PERCENTAGE;
    private static final StaminaWheelRenderer STAMINA_WHEEL_RENDERER;

    private ParagliderClientEventHandler() {
    }

    public static KeyBinding paragliderSettingsKey() {
        return paragliderSettingsKey;
    }

    public static void setParagliderSettingsKey(KeyBinding keyBinding) {
        if (paragliderSettingsKey != null) {
            throw new IllegalStateException("no");
        }
        paragliderSettingsKey = keyBinding;
    }

    @SubscribeEvent
    public static void onOffHandRender(RenderHandEvent event) {
        if (event.getHand() != Hand.OFF_HAND) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        PlayerMovement m = PlayerMovement.of((ICapabilityProvider)player);
        if (m != null && m.isParagliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGameOverlayTextRender(RenderGameOverlayEvent.Text event) {
        PlayerMovement h;
        ClientPlayerEntity p;
        if (ModCfg.debugPlayerMovement() && (p = Minecraft.func_71410_x().field_71439_g) != null && (h = PlayerMovement.of((ICapabilityProvider)p)) != null) {
            ArrayList right = event.getRight();
            ArrayList<String> arr = new ArrayList<String>();
            arr.add("State: " + (Object)((Object)h.getState()));
            arr.add((h.isDepleted() ? TextFormatting.RED : "") + "Stamina: " + h.getStamina() + " / " + h.getMaxStamina());
            arr.add(h.getStaminaVessels() + " Stamina Vessels, " + h.getHeartContainers() + " Heart Containers");
            arr.add(h.getRecoveryDelay() + " Recovery Delay");
            arr.add("Paragliding: " + h.isParagliding());
            arr.add("Stamina Wheel X: " + PERCENTAGE.format(ModCfg.staminaWheelX()) + ", Stamina Wheel Y: " + PERCENTAGE.format(ModCfg.staminaWheelY()));
            if (!right.isEmpty()) {
                arr.add("");
            }
            right.addAll(0, arr);
        }
    }

    @SubscribeEvent
    public static void afterGameOverlayRender(RenderGameOverlayEvent.Post event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof DisableStaminaRender || event.getType() != RenderGameOverlayEvent.ElementType.ALL || !ModCfg.paraglidingConsumesStamina() && !ModCfg.runningConsumesStamina()) {
            return;
        }
        MainWindow window = event.getWindow();
        int x = MathHelper.func_76125_a((int)((int)Math.round(ModCfg.staminaWheelX() * (double)window.func_198107_o())), (int)11, (int)(window.func_198107_o() - 2 - 10));
        int y = MathHelper.func_76125_a((int)((int)Math.round(ModCfg.staminaWheelY() * (double)window.func_198087_p())), (int)11, (int)(window.func_198087_p() - 2 - 10));
        STAMINA_WHEEL_RENDERER.renderStamina(event.getMatrixStack(), x, y, 25.0);
    }

    @SubscribeEvent
    public static void beforeGameOverlayRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && Minecraft.func_71410_x().field_71462_r instanceof StatueBargainScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r == null && ParagliderClientEventHandler.paragliderSettingsKey().func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ParagliderSettingScreen());
        }
    }

    static {
        PERCENTAGE = new DecimalFormat("#.#%");
        STAMINA_WHEEL_RENDERER = new InGameStaminaWheelRenderer();
    }
}

